package FlashReader;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Vector;

import doABC.ClassInfo;
import doABC.CpoolInfo;
import doABC.ExceptionInfo;
import doABC.InstanceInfo;
import doABC.MetadataInfo;
import doABC.MethodBodyInfo;
import doABC.MethodInfo;
import doABC.OptionInfo;
import doABC.ScriptInfo;
import doABC.TraitInfo;

/**
 * @author Mariusz.Dubielecki
 *
 */
public class AbcFile extends SwfTools {
	
	public ArrayList<OptionInfo> ENoption_info = new ArrayList<OptionInfo>();
	public ArrayList<TraitInfo> ENtrait_info = new ArrayList<TraitInfo>();
	public ArrayList<ExceptionInfo> ENexception_info = new ArrayList<ExceptionInfo>();
	
	public LinkedHashMap<Integer,String> methodsNames= new  LinkedHashMap<Integer,String>();
	public Vector<String> constNames = new Vector<String>();
	public Vector<String> ClassNames = new Vector<String>();
	
	private int minor_version; //u16
	private int major_version; //u16
	private CpoolInfo constant_pool;
	public  ArrayList<MethodInfo>  ENmethod_info = new ArrayList<MethodInfo>();
	public  ArrayList<MetadataInfo> ENmetadata_info = new ArrayList<MetadataInfo>();
	public  ArrayList<InstanceInfo> ENinstance_info = new ArrayList<InstanceInfo>();
	public  ArrayList<ClassInfo> ENclass_info = new ArrayList<ClassInfo>();
	public  ArrayList<ScriptInfo> ENscript_info = new ArrayList<ScriptInfo>();
	public  ArrayList<MethodBodyInfo> ENmethod_body_info = new ArrayList<MethodBodyInfo>() ;
	
	public AbcFile(int pos, ByteBuffer bbuf, SWF swf){
		super();

		//z zdokumentacji avm2 str.19
		minor_version = unsignedShort(bbuf.getShort());
		
		major_version = unsignedShort(bbuf.getShort());
		
		constant_pool = new CpoolInfo(this);
		
		constant_pool.cpool_info(bbuf, bbuf.position());

		MethodInfo.method_info(bbuf, bbuf.position(), constant_pool, this);
		
		MetadataInfo.metadata_info(bbuf, bbuf.position(), constant_pool, this);
		
		InstanceInfo.instance_info(bbuf, bbuf.position(), constant_pool, this);

		ClassInfo.class_info(bbuf, bbuf.position(), constant_pool, this);
		
		ScriptInfo.script_info(bbuf, bbuf.position(), constant_pool, this);
		
		MethodBodyInfo.method_body_info(bbuf, bbuf.position(), constant_pool, this, swf);

	}
	

	public byte[] generateDoABC(){
		ArrayList<Byte> abc = new ArrayList<Byte>();
		
		abc.addAll(getByteMinor_version());
		abc.addAll(getByteMajor_version());
		abc.addAll(constant_pool.toByteCode());
		abc.addAll(toByteCodeENmethod_info());
		abc.addAll(toByteCodeENmetadata_info());
		abc.addAll(toByteCodeENinstance_info());
		abc.addAll(toByteCodeENclass_info());
		abc.addAll(toByteCodeENscript_info());
		abc.addAll(toByteCodeENmethod_body_info());
		
		byte result[] = new byte[abc.size()];
		
		for(int i =0; i < abc.size();i++){
			result[i]=abc.get(i);
		}
		return result;
	}
	
	public int getMinor_version() {
		return minor_version;
	}

	public ArrayList<Byte> getByteMinor_version() {
		ArrayList<Byte> tmp = new ArrayList<Byte>();
		ByteBuffer bbuf = ByteBuffer.allocate(2);
		
		bbuf.putShort(Short.reverseBytes((short) minor_version));
		byte ar[] = bbuf.array();
		for (int i =0; i < ar.length;i++)
			tmp.add(ar[i]);
		
		return tmp;
	}


	public void setMinor_version(int minor_version) {
		this.minor_version = minor_version;
	}


	public int getMajor_version() {
		return major_version;
	}

	public ArrayList<Byte> getByteMajor_version() {
		ArrayList<Byte> tmp = new ArrayList<Byte>();
		ByteBuffer bbuf = ByteBuffer.allocate(2);
		
		bbuf.putShort(Short.reverseBytes((short) major_version));
		byte ar[] = bbuf.array();
		for (int i =0; i < ar.length;i++)
			tmp.add(ar[i]);
		
		return tmp;
	}

	public void setMajor_version(int major_version) {
		this.major_version = major_version;
	}


	public CpoolInfo getConstant_pool() {
		return constant_pool;
	}


	public void setConstant_pool(CpoolInfo constant_pool) {
		this.constant_pool = constant_pool;
	}

	
	public  ArrayList<Byte> toByteCodeENmethod_info(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		ArrayList<Byte> tmp1 =getUI32(ENmethod_info.size());
		for (int i=0;i<tmp1.size();i++)
			result.add(tmp1.get(i));
		
		for (MethodInfo method : ENmethod_info){
			ArrayList<Byte> tmp2 = method.toByteCode();
			for(int i = 0; i < tmp2.size();i++)
				result.add(tmp2.get(i));
		}
		return result;
	}
	
	public ArrayList<Byte> toByteCodeENmetadata_info(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		ArrayList<Byte> tmp1 =getUI32(ENmetadata_info.size());
		for (int i=0;i<tmp1.size();i++)
			result.add(tmp1.get(i));
		
		for (MetadataInfo metadata : ENmetadata_info){
			ArrayList<Byte> tmp2 = metadata.toByteCode();
			for(int i = 0; i < tmp2.size();i++)
				result.add(tmp2.get(i));
		}
		return result;
	}
	
	public ArrayList<Byte> toByteCodeENinstance_info(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		ArrayList<Byte> tmp1 =getUI32(ENinstance_info.size());
		for (int i=0;i<tmp1.size();i++)
			result.add(tmp1.get(i));
		
		for (InstanceInfo instance : ENinstance_info){
			ArrayList<Byte> tmp2 = instance.toByteCode();
			for(int i = 0; i < tmp2.size();i++)
				result.add(tmp2.get(i));
		}
		return result;
	}
	
	public ArrayList<Byte> toByteCodeENclass_info(){
		ArrayList<Byte> result = new ArrayList<Byte>();
	
		for (ClassInfo class_info : ENclass_info){
			ArrayList<Byte> tmp2 = class_info.toByteCode();
			for(int i = 0; i < tmp2.size();i++)
				result.add(tmp2.get(i));
		}
		return result;
	}
	
	public  ArrayList<Byte> toByteCodeENscript_info(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		ArrayList<Byte> tmp1 =getUI32(ENscript_info.size());
		for (int i=0;i<tmp1.size();i++)
			result.add(tmp1.get(i));
		
		for (ScriptInfo script : ENscript_info){
			ArrayList<Byte> tmp2 = script.toByteCode();
			for(int i = 0; i < tmp2.size();i++)
				result.add(tmp2.get(i));
		}
		return result;
	}
	
	public  ArrayList<Byte> toByteCodeENmethod_body_info(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		ArrayList<Byte> tmp1 =getUI32(ENmethod_body_info.size());
		for (int i=0;i<tmp1.size();i++)
			result.add(tmp1.get(i));
		
		for (MethodBodyInfo method_body : ENmethod_body_info){
			ArrayList<Byte> tmp2 = method_body.toByteCode();
			for(int i = 0; i < tmp2.size();i++)
				result.add(tmp2.get(i));
		}
		return result;
	}



	public String toString(){
		return "AbcFile";
	}
	
}
